<?php
return [
    'controllers' => [
        'factories' => [],
    ],
    'router' => [
        'routes' => [
            'iniciaisgerenciador.rest.file' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/file[/:file_id]',
                    'defaults' => [
                        'controller' => 'iniciaisgerenciador\\V1\\Rest\\File\\Controller',
                    ],
                ],
            ],
            'iniciaisgerenciador.rest.process' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/process[/:process_id]',
                    'defaults' => [
                        'controller' => 'iniciaisgerenciador\\V1\\Rest\\Process\\Controller',
                    ],
                ],
            ],
            'iniciaisgerenciador.rest.folder' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/folder[/:folder_id]',
                    'defaults' => [
                        'controller' => 'iniciaisgerenciador\\V1\\Rest\\Folder\\Controller',
                    ],
                ],
            ],
            'iniciaisgerenciador.rest.envia-arquivo' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/envia-arquivo[/:envia_arquivo_id]',
                    'defaults' => [
                        'controller' => 'iniciaisgerenciador\\V1\\Rest\\EnviaArquivo\\Controller',
                    ],
                ],
            ],
        ],
    ],
    'zf-versioning' => [
        'uri' => [
            1 => 'iniciaisgerenciador.rest.file',
            2 => 'iniciaisgerenciador.rest.process',
            3 => 'iniciaisgerenciador.rest.folder',
            4 => 'iniciaisgerenciador.rest.envia-arquivo',
        ],
    ],
    'zf-rpc' => [],
    'zf-content-negotiation' => [
        'controllers' => [
            'iniciaisgerenciador\\V1\\Rest\\File\\Controller' => 'HalJson',
            'iniciaisgerenciador\\V1\\Rest\\Process\\Controller' => 'Json',
            'iniciaisgerenciador\\V1\\Rest\\Folder\\Controller' => 'HalJson',
            'iniciaisgerenciador\\V1\\Rest\\EnviaArquivo\\Controller' => 'HalJson',
        ],
        'accept_whitelist' => [
            'iniciaisgerenciador\\V1\\Rest\\File\\Controller' => [
                0 => 'application/vnd.iniciaisgerenciador.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ],
            'iniciaisgerenciador\\V1\\Rest\\Process\\Controller' => [
                0 => 'application/vnd.iniciaisgerenciador.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ],
            'iniciaisgerenciador\\V1\\Rest\\Folder\\Controller' => [
                0 => 'application/vnd.iniciaisgerenciador.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ],
            'iniciaisgerenciador\\V1\\Rest\\EnviaArquivo\\Controller' => [
                0 => 'application/vnd.iniciaisgerenciador.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ],
        ],
        'content_type_whitelist' => [
            'iniciaisgerenciador\\V1\\Rest\\File\\Controller' => [
                0 => 'application/vnd.iniciaisgerenciador.v1+json',
                1 => 'application/json',
            ],
            'iniciaisgerenciador\\V1\\Rest\\Process\\Controller' => [
                0 => 'application/vnd.iniciaisgerenciador.v1+json',
                1 => 'application/json',
            ],
            'iniciaisgerenciador\\V1\\Rest\\Folder\\Controller' => [
                0 => 'application/vnd.iniciaisgerenciador.v1+json',
                1 => 'application/json',
            ],
            'iniciaisgerenciador\\V1\\Rest\\EnviaArquivo\\Controller' => [
                0 => 'application/vnd.iniciaisgerenciador.v1+json',
                1 => 'application/json',
            ],
        ],
    ],
    'zf-content-validation' => [
        'iniciaisgerenciador\\V1\\Rest\\File\\Controller' => [
            'input_filter' => 'iniciaisgerenciador\\V1\\Rest\\File\\Validator',
        ],
        'iniciaisgerenciador\\V1\\Rest\\Process\\Controller' => [
            'input_filter' => 'iniciaisgerenciador\\V1\\Rest\\Process\\Validator',
        ],
        'iniciaisgerenciador\\V1\\Rest\\Folder\\Controller' => [
            'input_filter' => 'iniciaisgerenciador\\V1\\Rest\\Folder\\Validator',
        ],
        'iniciaisgerenciador\\V1\\Rest\\EnviaArquivo\\Controller' => [
            'input_filter' => 'iniciaisgerenciador\\V1\\Rest\\EnviaArquivo\\Validator',
        ],
    ],
    'input_filter_specs' => [
        'iniciaisgerenciador\\V1\\Rpc\\Arquivos\\Validator' => [
            0 => [
                'required' => true,
                'validators' => [],
                'filters' => [],
                'name' => 'arquivos',
                'type' => \Zend\InputFilter\FileInput::class,
                'field_type' => 'file',
            ],
        ],
        'iniciaisgerenciador\\V1\\Rest\\File\\Validator' => [
            0 => [
                'name' => 'folder_id',
                'required' => true,
                'filters' => [
                    0 => [
                        'name' => \Zend\Filter\StripTags::class,
                    ],
                    1 => [
                        'name' => \Zend\Filter\Digits::class,
                    ],
                ],
                'validators' => [
                    0 => [
                        'name' => 'ZF\\ContentValidation\\Validator\\DbRecordExists',
                        'options' => [
                            'adapter' => 'dummy',
                            'table' => 'folder',
                            'field' => 'id',
                        ],
                    ],
                ],
            ],
            1 => [
                'name' => 'name',
                'required' => true,
                'filters' => [
                    0 => [
                        'name' => \Zend\Filter\StringTrim::class,
                    ],
                    1 => [
                        'name' => \Zend\Filter\StripTags::class,
                    ],
                ],
                'validators' => [
                    0 => [
                        'name' => \Zend\Validator\StringLength::class,
                        'options' => [
                            'min' => 1,
                            'max' => '255',
                        ],
                    ],
                ],
            ],
            2 => [
                'name' => 'file_name',
                'required' => true,
                'filters' => [
                    0 => [
                        'name' => \Zend\Filter\StringTrim::class,
                    ],
                    1 => [
                        'name' => \Zend\Filter\StripTags::class,
                    ],
                ],
                'validators' => [
                    0 => [
                        'name' => \Zend\Validator\StringLength::class,
                        'options' => [
                            'min' => 1,
                            'max' => '255',
                        ],
                    ],
                ],
            ],
        ],
        'iniciaisgerenciador\\V1\\Rest\\Process\\Validator' => [
            0 => [
                'name' => 'code',
                'required' => true,
                'filters' => [
                    0 => [
                        'name' => \Zend\Filter\StringTrim::class,
                    ],
                    1 => [
                        'name' => \Zend\Filter\StripTags::class,
                    ],
                ],
                'validators' => [
                    0 => [
                        'name' => \Zend\Validator\StringLength::class,
                        'options' => [
                            'min' => 1,
                            'max' => '50',
                        ],
                    ],
                ],
            ],
            1 => [
                'name' => 'customer',
                'required' => true,
                'filters' => [
                    0 => [
                        'name' => \Zend\Filter\StringTrim::class,
                    ],
                    1 => [
                        'name' => \Zend\Filter\StripTags::class,
                    ],
                ],
                'validators' => [
                    0 => [
                        'name' => \Zend\Validator\StringLength::class,
                        'options' => [
                            'min' => 1,
                            'max' => '100',
                        ],
                    ],
                ],
            ],
            2 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'id',
                'continue_if_empty' => true,
                'allow_empty' => true,
            ],
        ],
        'iniciaisgerenciador\\V1\\Rest\\Folder\\Validator' => [
            0 => [
                'name' => 'process_id',
                'required' => true,
                'filters' => [
                    0 => [
                        'name' => \Zend\Filter\StripTags::class,
                    ],
                    1 => [
                        'name' => \Zend\Filter\Digits::class,
                    ],
                ],
                'validators' => [
                    0 => [
                        'name' => 'ZF\\ContentValidation\\Validator\\DbRecordExists',
                        'options' => [
                            'adapter' => 'dummy',
                            'table' => 'process',
                            'field' => 'id',
                        ],
                    ],
                ],
            ],
            1 => [
                'name' => 'name',
                'required' => true,
                'filters' => [
                    0 => [
                        'name' => \Zend\Filter\StringTrim::class,
                    ],
                    1 => [
                        'name' => \Zend\Filter\StripTags::class,
                    ],
                ],
                'validators' => [
                    0 => [
                        'name' => \Zend\Validator\StringLength::class,
                        'options' => [
                            'min' => 1,
                            'max' => '50',
                        ],
                    ],
                ],
            ],
        ],
        'iniciaisgerenciador\\V1\\Rest\\EnviaArquivo\\Validator' => [
            0 => [
                'required' => true,
                'validators' => [],
                'filters' => [],
                'name' => 'arquivo',
                'type' => \Zend\InputFilter\FileInput::class,
            ],
        ],
    ],
    'zf-rest' => [
        'iniciaisgerenciador\\V1\\Rest\\File\\Controller' => [
            'listener' => \iniciaisgerenciador\V1\Rest\File\FileResource::class,
            'route_name' => 'iniciaisgerenciador.rest.file',
            'route_identifier_name' => 'file_id',
            'collection_name' => 'file',
            'entity_http_methods' => [
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
                4 => 'POST',
            ],
            'collection_http_methods' => [
                0 => 'GET',
                1 => 'POST',
            ],
            'collection_query_whitelist' => [
                0 => 'folder_id',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \iniciaisgerenciador\V1\Rest\File\FileEntity::class,
            'collection_class' => \iniciaisgerenciador\V1\Rest\File\FileCollection::class,
            'service_name' => 'file',
        ],
        'iniciaisgerenciador\\V1\\Rest\\Process\\Controller' => [
            'listener' => \iniciaisgerenciador\V1\Rest\Process\ProcessResource::class,
            'route_name' => 'iniciaisgerenciador.rest.process',
            'route_identifier_name' => 'process_id',
            'collection_name' => 'process',
            'entity_http_methods' => [
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
                4 => 'POST',
            ],
            'collection_http_methods' => [
                0 => 'GET',
                1 => 'POST',
            ],
            'collection_query_whitelist' => [
                0 => 'code',
            ],
            'page_size' => '2500000',
            'page_size_param' => 150,
            'entity_class' => \iniciaisgerenciador\V1\Rest\Process\ProcessEntity::class,
            'collection_class' => \iniciaisgerenciador\V1\Rest\Process\ProcessCollection::class,
            'service_name' => 'process',
        ],
        'iniciaisgerenciador\\V1\\Rest\\Folder\\Controller' => [
            'listener' => \iniciaisgerenciador\V1\Rest\Folder\FolderResource::class,
            'route_name' => 'iniciaisgerenciador.rest.folder',
            'route_identifier_name' => 'folder_id',
            'collection_name' => 'folder',
            'entity_http_methods' => [
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ],
            'collection_http_methods' => [
                0 => 'GET',
                1 => 'POST',
            ],
            'collection_query_whitelist' => [
                0 => 'process_id',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \iniciaisgerenciador\V1\Rest\Folder\FolderEntity::class,
            'collection_class' => \iniciaisgerenciador\V1\Rest\Folder\FolderCollection::class,
            'service_name' => 'folder',
        ],
        'iniciaisgerenciador\\V1\\Rest\\EnviaArquivo\\Controller' => [
            'listener' => \iniciaisgerenciador\V1\Rest\EnviaArquivo\EnviaArquivoResource::class,
            'route_name' => 'iniciaisgerenciador.rest.envia-arquivo',
            'route_identifier_name' => 'envia_arquivo_id',
            'collection_name' => 'envia_arquivo',
            'entity_http_methods' => [
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
                4 => 'POST',
            ],
            'collection_http_methods' => [
                0 => 'GET',
                1 => 'POST',
            ],
            'collection_query_whitelist' => [],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \iniciaisgerenciador\V1\Rest\EnviaArquivo\EnviaArquivoEntity::class,
            'collection_class' => \iniciaisgerenciador\V1\Rest\EnviaArquivo\EnviaArquivoCollection::class,
            'service_name' => 'enviaArquivo',
        ],
    ],
    'zf-hal' => [
        'metadata_map' => [
            \iniciaisgerenciador\V1\Rest\File\FileEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'iniciaisgerenciador.rest.file',
                'route_identifier_name' => 'file_id',
                'hydrator' => \Zend\Hydrator\ArraySerializable::class,
            ],
            \iniciaisgerenciador\V1\Rest\File\FileCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'iniciaisgerenciador.rest.file',
                'route_identifier_name' => 'file_id',
                'is_collection' => true,
            ],
            \iniciaisgerenciador\V1\Rest\Process\ProcessEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'iniciaisgerenciador.rest.process',
                'route_identifier_name' => 'process_id',
                'hydrator' => \Zend\Hydrator\ArraySerializable::class,
            ],
            \iniciaisgerenciador\V1\Rest\Process\ProcessCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'iniciaisgerenciador.rest.process',
                'route_identifier_name' => 'process_id',
                'is_collection' => true,
            ],
            \iniciaisgerenciador\V1\Rest\Folder\FolderEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'iniciaisgerenciador.rest.folder',
                'route_identifier_name' => 'folder_id',
                'hydrator' => \Zend\Hydrator\ArraySerializable::class,
            ],
            \iniciaisgerenciador\V1\Rest\Folder\FolderCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'iniciaisgerenciador.rest.folder',
                'route_identifier_name' => 'folder_id',
                'is_collection' => true,
            ],
            \iniciaisgerenciador\V1\Rest\EnviaArquivo\EnviaArquivoEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'iniciaisgerenciador.rest.envia-arquivo',
                'route_identifier_name' => 'envia_arquivo_id',
                'hydrator' => \Zend\Hydrator\ArraySerializable::class,
            ],
            \iniciaisgerenciador\V1\Rest\EnviaArquivo\EnviaArquivoCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'iniciaisgerenciador.rest.envia-arquivo',
                'route_identifier_name' => 'envia_arquivo_id',
                'is_collection' => true,
            ],
        ],
    ],
    'zf-apigility' => [
        'db-connected' => [
            \iniciaisgerenciador\V1\Rest\File\FileResource::class => [
                'adapter_name' => 'dummy',
                'table_name' => 'file',
                'hydrator_name' => \Zend\Hydrator\ArraySerializable::class,
                'controller_service_name' => 'iniciaisgerenciador\\V1\\Rest\\File\\Controller',
                'entity_identifier_name' => 'id',
                'table_service' => 'iniciaisgerenciador\\V1\\Rest\\File\\FileResource\\Table',
                'resource_class' => \iniciaisgerenciador\V1\Rest\File\FileResource::class,
            ],
            \iniciaisgerenciador\V1\Rest\Process\ProcessResource::class => [
                'adapter_name' => 'dummy',
                'table_name' => 'process',
                'hydrator_name' => \Zend\Hydrator\ArraySerializable::class,
                'controller_service_name' => 'iniciaisgerenciador\\V1\\Rest\\Process\\Controller',
                'entity_identifier_name' => 'code',
                'table_service' => 'iniciaisgerenciador\\V1\\Rest\\Process\\ProcessResource\\Table',
                'resource_class' => \iniciaisgerenciador\V1\Rest\Process\ProcessResource::class,
            ],
            \iniciaisgerenciador\V1\Rest\Folder\FolderResource::class => [
                'adapter_name' => 'dummy',
                'table_name' => 'folder',
                'hydrator_name' => \Zend\Hydrator\ArraySerializable::class,
                'controller_service_name' => 'iniciaisgerenciador\\V1\\Rest\\Folder\\Controller',
                'entity_identifier_name' => 'id',
                'resource_class' => \iniciaisgerenciador\V1\Rest\Folder\FolderResource::class,
                'table_service' => 'iniciaisgerenciador\\V1\\Rest\\Folder\\FolderResource\\Table',
            ],
        ],
    ],
    'zf-mvc-auth' => [
        'authorization' => [
            'iniciaisgerenciador\\V1\\Rest\\Process\\Controller' => [
                'collection' => [
                    'GET' => false,
                    'POST' => false,
                    'PUT' => false,
                    'PATCH' => false,
                    'DELETE' => false,
                ],
                'entity' => [
                    'GET' => false,
                    'POST' => false,
                    'PUT' => false,
                    'PATCH' => true,
                    'DELETE' => true,
                ],
            ],
        ],
    ],
    'service_manager' => [
        'factories' => [
            \iniciaisgerenciador\V1\Rest\EnviaArquivo\EnviaArquivoResource::class => \iniciaisgerenciador\V1\Rest\EnviaArquivo\EnviaArquivoResourceFactory::class,
        ],
    ],
];
